//
//  IFViewController.h
//  PDFReader
//
//  Created by Dong Li on 12-4-25.
//  Copyright (c) 2013年 ITX. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface IFViewController : UIViewController {
@protected
    UIBarButtonItem *_rotationItem;
    UIStatusBarStyle _statusBarStyle;
    
@private
    UIInterfaceOrientation _layoutInterfaceOrientation;
    
    struct {
        unsigned int fullScreen:1;
        unsigned int visible:1;
    } _flags;
}

@property (nonatomic, assign, getter = isFullScreen) BOOL fullScreen;
@property (nonatomic, assign, readonly) BOOL isVisible;

- (void)releaseSubviews;
- (void)reverseFullScreen;
- (void)layoutWithContentSize:(const CGSize)contentSize;
- (void)onInvertRotationLock;

@end
